<?php

namespace Discovereel\Sections;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Section extends Model 
{

    protected $table = 'sections';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function theme()
    {
        return $this->belongsTo('Theme');
    }

    public function columns()
    {
        return $this->belongsToMany('Column')->withTimestamps();
    }

}